<?php
namespace VM\FinancialStatementsBundle\Services;

use VM\FinancialStatementsBundle\Services\DataStructure\FinansowanieProdukcjiDS;

class FinansowanieProdukcji extends CommonMethods
{
    /**
     * @var float
     */
    protected $udzialWRynku = 0.00;

    /**
     * @var int
     */
    protected $cenaProduktu = 0;

    /**
     * @var float
     */
    protected $nakladyNaPiR = 0.00;

    /**
     * @var float
     */
    protected $nakladyNaInnowacje = 0.00;

    /**
     * @var array
     */
    protected $kosztyStale = [];

    /**
     * @var array
     */
    protected $kosztyZmienne = [];

    /**
     * @var int
     */
    protected $iteracja = 0;

    /**
     * @var float
     */
    protected $wielkoscRynku = 0;

    /**
     * @var float
     */
    protected $mozliwosciProdukcyjne = 0;

    /**
     * @var int
     */
    protected $rokPoczatkowy = 1;

    /**
     * @var int
     */
    protected $planowanaProdukcja = 0;

    /**
     * @var float
     */
    protected $bazowyKosztProdukcji = 2000;

    /**
     * @var float
     */
    protected $obnizkaBrakow = 0;

    /**
     * @var FinansowanieProdukcjiDS
     */
    protected $DataStructure;

    /**
     * @var array
     */
    protected $funkcjePopytu = [];

    protected $wariantyProporcjonalne = [];
    protected $wariantyElastyczne = [];

    /**
     * @var bool
     */
    protected $firstTime = true;

    /**
     * Constructor
     */
    protected function __construct(FinansowanieProdukcjiDS $FinansowanieProdukcjiDS)
    {
        $this->assignDataFromDataStructure($FinansowanieProdukcjiDS);
        $this->iteracja = $this->rokPoczatkowy;

        $this->evaluateFunkcjePopytu($this->cenaProduktu, 1, $this->wielkoscRynku);
        $this->evaluateWariantProporcjonalny();
    }

    protected function assignDataFromDataStructure(FinansowanieProdukcjiDS $FinansowanieProdukcjiDS)
    {
        if($this->firstTime)
        {
            $this->DataStructure = $FinansowanieProdukcjiDS;
            $this->udzialWRynku = $FinansowanieProdukcjiDS->udzialWRynku;
            $this->cenaProduktu = $FinansowanieProdukcjiDS->cenaProduktu;
            $this->nakladyNaPiR = $FinansowanieProdukcjiDS->nakladyNaPiR;
            $this->nakladyNaInnowacje = $FinansowanieProdukcjiDS->nakladyNaInnowacje;
            $this->kosztyStale = $FinansowanieProdukcjiDS->kosztyStale;
            $this->kosztyZmienne = $FinansowanieProdukcjiDS->kosztyZmienne;
            $this->wielkoscRynku = $FinansowanieProdukcjiDS->wielkoscRynku;
            $this->rokPoczatkowy = $FinansowanieProdukcjiDS->rokPoczatkowy;
            $this->mozliwosciProdukcyjne = $FinansowanieProdukcjiDS->mozliwosciProdukcyjne;
            $this->planowanaProdukcja = $FinansowanieProdukcjiDS->planowanaProdukcja;
            $this->bazowyKosztProdukcji = $FinansowanieProdukcjiDS->bazowyKosztProdukcji;
            $this->obnizkaBrakow = $FinansowanieProdukcjiDS->obnizkaBrakow;

            $this->firstTime = false;
        }
        else
        {
            $this->DataStructure = $FinansowanieProdukcjiDS;
            $this->wielkoscRynku = $FinansowanieProdukcjiDS->wielkoscRynku;
            $this->cenaProduktu = $FinansowanieProdukcjiDS->cenaProduktu;
            $this->mozliwosciProdukcyjne = $FinansowanieProdukcjiDS->mozliwosciProdukcyjne;
            $this->planowanaProdukcja = $FinansowanieProdukcjiDS->planowanaProdukcja;
            $this->nakladyNaPiR = $FinansowanieProdukcjiDS->nakladyNaPiR;
            $this->nakladyNaInnowacje = $FinansowanieProdukcjiDS->nakladyNaInnowacje;
            $this->kosztyStale = $FinansowanieProdukcjiDS->kosztyStale;
            $this->kosztyZmienne = $FinansowanieProdukcjiDS->kosztyZmienne;
            $this->obnizkaBrakow = $FinansowanieProdukcjiDS->obnizkaBrakow;
        }

    }

    public static function create(FinansowanieProdukcjiDS $FinansowanieProdukcjiDS)
    {
        if($FinansowanieProdukcjiDS->validate())
        {
            return new FinansowanieProdukcji($FinansowanieProdukcjiDS);
        }
        else
        {
            throw new \Exception('Dane wejściowe nie przeszły walidacji.');
        }
    }

    public function nextIteration(FinansowanieProdukcjiDS $FinansowanieProdukcjiDSNowy)
    {
        if($FinansowanieProdukcjiDSNowy->validate())
        {
            $this->iteracja++;

            $staraCena = $this->cenaProduktu;
            $this->assignDataFromDataStructure($FinansowanieProdukcjiDSNowy);

            $this->evaluateFunkcjePopytu($this->cenaProduktu, $staraCena, $this->wielkoscRynku);
            $this->evaluateWariantProporcjonalny();
        }
        else
        {
            throw new \Exception('Dane wejściowe nie przeszły walidacji.');
        }
    }

    protected function evaluateWariantProporcjonalny()
    {
        $wariant = new \stdClass();
        $wariant->cenaProduktu = $this->cenaProduktu;

        $udzialWRynkuDalszaIteracja = $this->iteracja < $this->rokPoczatkowy+1? $this->udzialWRynku:
            $this->division($this->wariantyProporcjonalne[$this->iteracja-1]->nowyUdzialWRynku,
                $this->wielkoscRynku) *
            $this->division($this->funkcjePopytu[$wariant->cenaProduktu]['Q2'],
                $this->funkcjePopytu[$this->wariantyProporcjonalne[$this->iteracja-1]->cenaProduktu]['Q2']);

        $wariant->udzialWRynku = $udzialWRynkuDalszaIteracja + 0.00005;

        $wariant->udzialWRynku = $wariant->udzialWRynku > 1? 1: $wariant->udzialWRynku;

        $wariant->udzialWRynkuWZlotych = $wariant->udzialWRynku * $this->funkcjePopytu[$wariant->cenaProduktu]['Wielkosc rynku'];
        $wariant->udzialWRynkuWSztukach = floor($wariant->cenaProduktu == 0? 0: $this->division($wariant->udzialWRynkuWZlotych, $wariant->cenaProduktu));

        $wariant->mozliwosciProdukcyjne = $this->mozliwosciProdukcyjne;


        $wariant->planowanaProdukcja = $this->planowanaProdukcja;
        $wariant->mozliwaProdukcja = $this->planowanaProdukcja;
        $poprzedniMnoznikBrakow = $this->iteracja < $this->rokPoczatkowy+1? 1: $this->wariantyProporcjonalne[$this->iteracja-1]->mnoznikBrakow;
        $wariant->nakladyNaPiR = $this->nakladyNaPiR/100*$poprzedniMnoznikBrakow;
        $wariant->nakladyNaPiRKwota = $wariant->udzialWRynkuWZlotych * $wariant->nakladyNaPiR;

        $wariant->nakladyNaInnowacje = $this->nakladyNaInnowacje/100;

        $wariant->nakladyNaInnowacjeKwota = $wariant->udzialWRynkuWZlotych * $wariant->nakladyNaInnowacje;

        $wariant->efektPiRDlaCeny = $wariant->nakladyNaPiR - 0.05 >= 0? sqrt($wariant->nakladyNaPiR - 0.05)/4: $this->division(-0.005, $wariant->nakladyNaPiR);
        $wariant->efektInnowacjiDlaCeny = $wariant->nakladyNaInnowacje - 0.02 >= 0? sqrt($wariant->nakladyNaInnowacje - 0.02)/3: $this->division(-0.005, $wariant->nakladyNaInnowacje);

        $wariant->efektPiRDlaCeny = $wariant->efektPiRDlaCeny < -0.5? -0.5: $wariant->efektPiRDlaCeny;
        $wariant->efektInnowacjiDlaCeny = $wariant->efektInnowacjiDlaCeny < -0.5? -0.5: $wariant->efektInnowacjiDlaCeny;

        $wariant->bazowyKosztProdukcji = $this->bazowyKosztProdukcji;
        $wariant->biezacyKosztProdukcji = $this->kosztyZmienne['materialowe']['cenaJednostki'];
        $zmiana = ((float)$wariant->biezacyKosztProdukcji - (float)$wariant->bazowyKosztProdukcji)/$wariant->bazowyKosztProdukcji * 100;
        $wariant->mnoznikBrakow = (1-1/(1+exp($zmiana)))*2;

        $wariant->obnizkaBrakow = $this->obnizkaBrakow/100;
        $wariant->brakiBazowe = 0.03 * $wariant->mnoznikBrakow;
        $wariant->brakiBazowe = $wariant->brakiBazowe - ($wariant->brakiBazowe * $wariant->obnizkaBrakow);
        $wariant->kosztyUtrzymaniaJakosci = 0.00;
        $wariant->kosztyBraki = $this->iteracja < 1+$this->rokPoczatkowy? $wariant->brakiBazowe:
            $this->wariantyProporcjonalne[$this->iteracja-1]->kosztyBraki * 0.6;

        if($wariant->mozliwaProdukcja >= $wariant->mozliwosciProdukcyjne)
        {
            $wariant->mozliwaProdukcja = $wariant->mozliwosciProdukcyjne;
        }

        if($wariant->mozliwaProdukcja < $wariant->udzialWRynkuWSztukach)
        {
            $wariant->produkcjaLacznie = $wariant->kosztyBraki >= 1? 0: floor($wariant->mozliwaProdukcja/(1-$wariant->kosztyBraki));
            $wariant->sprzedazLacznie = $wariant->mozliwaProdukcja;
        }
        else
        {
            $wariant->produkcjaLacznie = $wariant->kosztyBraki >= 1? 0: floor($wariant->mozliwaProdukcja/(1-$wariant->kosztyBraki));
            $wariant->sprzedazLacznie = $wariant->udzialWRynkuWSztukach;
        }

        $efektyPiRBiR = $wariant->efektPiRDlaCeny + $wariant->efektInnowacjiDlaCeny;

        if($efektyPiRBiR <= 0)
        {
            $efektyPiRBiR += (0.2 - 0.2*(1-abs($efektyPiRBiR)));
        }

        $sprzedazPoEfekcieBiRPiR =
            $wariant->sprzedazLacznie *
            (1 + $efektyPiRBiR)/
            (1 - $wariant->brakiBazowe * 0.4);
        $produkcjaPoEfekcieBiRPiR =
            $sprzedazPoEfekcieBiRPiR/(1-$wariant->kosztyBraki);
        $wariant->produkcjaPoEfekcieBiRPiR =
            $produkcjaPoEfekcieBiRPiR > $wariant->mozliwosciProdukcyjne?
                $wariant->mozliwosciProdukcyjne: $produkcjaPoEfekcieBiRPiR;

        if($wariant->produkcjaPoEfekcieBiRPiR < $wariant->planowanaProdukcja)
        {
            if($wariant->produkcjaPoEfekcieBiRPiR < $wariant->mozliwaProdukcja)
            {
                $wariant->produkcjaPoEfekcieBiRPiR = $wariant->mozliwaProdukcja;
            }
        }

        $wariant->sprzedazPoEfekcieBiRPiR =
            $sprzedazPoEfekcieBiRPiR > $wariant->produkcjaPoEfekcieBiRPiR?
                $wariant->produkcjaPoEfekcieBiRPiR: $sprzedazPoEfekcieBiRPiR;

        $wariant->sprzedazLacznie = floor($wariant->sprzedazPoEfekcieBiRPiR);
        $wariant->produkcjaLacznie = floor($wariant->produkcjaPoEfekcieBiRPiR);

        $poprawkaZapasow = 0;
        if($wariant->mozliwaProdukcja < $wariant->udzialWRynkuWSztukach)
        {
            $roznica = $wariant->udzialWRynkuWSztukach - $wariant->mozliwaProdukcja;
            $zapasy = $this->iteracja < $this->rokPoczatkowy+1? 0:
                $this->wariantyProporcjonalne[$this->iteracja-1]->zapasy;

            if($zapasy < $roznica)
            {
                $poprawkaZapasow = -$zapasy;
            }
            else
            {
                $poprawkaZapasow = -$roznica;
            }
        }

        $wariant->zapasy = $this->iteracja < $this->rokPoczatkowy+1?
            $wariant->mozliwaProdukcja - $wariant->sprzedazLacznie:
            $wariant->mozliwaProdukcja - $wariant->sprzedazLacznie +
            $this->wariantyProporcjonalne[$this->iteracja-1]->zapasy +
            $poprawkaZapasow;

        if($poprawkaZapasow != 0)
        {
            $wariant->sprzedazLacznie += abs($poprawkaZapasow);
        }

        $wariant->nowyUdzialWRynku = $wariant->sprzedazLacznie * $wariant->cenaProduktu;

        $wariant->kosztyStaleRazem = 0;
        $wariant->kosztyStale = [];
        foreach($this->kosztyStale as $key => $koszt)
        {
            $wariant->kosztyStale[$key] = ($koszt['q'] * $koszt['kj']);
            $wariant->kosztyStaleRazem += $wariant->kosztyStale[$key];
        }

        $wariant->kosztProdukcjiSztuki = 0;

        $wariant->kosztyZmienneRazemWartosciowo = 0;
        $wariant->kosztyZmienneRazem = 0;
        $wariant->kosztyZmienneWartosciowo = [];
        foreach($this->kosztyZmienne as $key => $koszt)
        {
            $wariant->kosztyZmienneWartosciowo[$key] = $koszt['kjz'] * $koszt['cenaJednostki'];
            $wariant->kosztProdukcjiSztuki += $koszt['kjz'] * $koszt['cenaJednostki'];
            $wariant->kosztyZmienneRazemWartosciowo += $wariant->kosztyZmienneWartosciowo[$key];
            $wariant->kosztyZmienneKwota[$key] = $koszt['kjz'] * $koszt['cenaJednostki'] * $wariant->produkcjaLacznie;
            $wariant->kosztyZmienneRazem += $koszt['kjz'] * $koszt['cenaJednostki'] * $wariant->produkcjaLacznie;
        }

        $wariant->kosztyBrakowWSztukach = $wariant->produkcjaLacznie * $wariant->brakiBazowe;
        $wariant->kosztyBrakowWZlotowkach = $wariant->kosztyBrakowWSztukach * $wariant->kosztyZmienneRazemWartosciowo;
        $wariant->przychodyZBrakow = $this->iteracja < 1+$this->rokPoczatkowy? 0: $wariant->kosztyBrakowWSztukach * $wariant->cenaProduktu;

        $wariant->przychodyLacznie = $wariant->przychodyZBrakow + $wariant->nowyUdzialWRynku;
        $wariant->kosztyLacznie = $this->iteracja < 1+$this->rokPoczatkowy?
            $wariant->nakladyNaPiRKwota + $wariant->nakladyNaInnowacjeKwota + $wariant->kosztyStaleRazem + $wariant->kosztyZmienneRazem:
            $wariant->nakladyNaPiRKwota + $wariant->nakladyNaInnowacjeKwota + $wariant->kosztyStaleRazem + $wariant->kosztyZmienneRazem + $wariant->kosztyUtrzymaniaJakosci;
        $wariant->wynikBrutto = $wariant->przychodyLacznie - $wariant->kosztyLacznie;

        $this->wariantyProporcjonalne[$this->iteracja] = $wariant;

//        echo "<pre>";
//        print_r($wariant);
    }

    private function evaluateFunkcjePopytu($cena = 24, $staraCena, $wielkoscRynku = 2000000000)
    {
        $nakladyNaPiRMinimalne = 0.05;
        $nakladyNaInnowacyjnoscMinimalne = 0.02;
        $nakladyRocznie = 100000.00;

        $pom = []; //zmienna pomocnicza, zeby byla krotka nazwa

        $pom[$cena]['Wielkosc rynku'] = $wielkoscRynku;
        $pom[$cena]['Cena produktu'] = $cena < 1? 1: $cena;
        $pom[$cena]['Q2'] = $pom[$cena]['Wielkosc rynku']/$pom[$cena]['Cena produktu'];
        $pom[$cena]['PiR min'] = $nakladyNaPiRMinimalne;
        $pom[$cena]['Inn min'] = $nakladyNaInnowacyjnoscMinimalne;
        $pom[$cena]['PiR+'] = $cena/100;
        $pom[$cena]['PiR+ sprzedaz'] = sqrt($pom[$cena]['PiR+'])/4;
        $pom[$cena]['Inn+'] = $cena/100;
        $pom[$cena]['Inn+ sprzedaz'] = sqrt($pom[$cena]['Inn+'])/3;
        $pom[$cena]['Spadek ilosci brakow'] = ($cena*2)/100;
        $pom[$cena]['Naklady rocznie'] = $cena <= 20? 100000: $cena <= 30? 200000: 800000;

        $pom[$staraCena]['Wielkosc rynku'] = $wielkoscRynku;
        $pom[$staraCena]['Cena produktu'] = $staraCena < 1? 1: $staraCena;
        $pom[$staraCena]['Q2'] = $pom[$staraCena]['Wielkosc rynku']/$pom[$staraCena]['Cena produktu'];
        $pom[$staraCena]['PiR min'] = $nakladyNaPiRMinimalne;
        $pom[$staraCena]['Inn min'] = $nakladyNaInnowacyjnoscMinimalne;
        $pom[$staraCena]['PiR+'] = $staraCena/100;
        $pom[$staraCena]['PiR+ sprzedaz'] = sqrt($pom[$staraCena]['PiR+'])/4;
        $pom[$staraCena]['Inn+'] = $staraCena/100;
        $pom[$staraCena]['Inn+ sprzedaz'] = sqrt($pom[$staraCena]['Inn+'])/3;
        $pom[$staraCena]['Spadek ilosci brakow'] = ($staraCena*2)/100;
        $pom[$staraCena]['Naklady rocznie'] = $staraCena <= 20? 100000: $staraCena <= 30? 200000: 800000;

        $this->funkcjePopytu = $pom;
    }

    public function getFunkcjaPopytu()
    {
        return $this->funkcjePopytu;
    }

    public function getRokPoczatkowy()
    {
        return $this->rokPoczatkowy;
    }

    public function getResultsOf($name)
    {
        return $this->$name;
    }

    public function getWariantProporcjonalnyByYear($rok = 0)
    {
        if($rok == 0)
        {
            return $this->wariantyProporcjonalne[count($this->wariantyProporcjonalne)-1];
        }
        try
        {
            if($rok > $this->iteracja || $rok < $this->rokPoczatkowy) {
                throw new \Exception("Iteracja mniejsza niz rok poczatkowy lub większa niż dotychczas obliczone.");
            }
            return $this->wariantyProporcjonalne[$rok];
        }
        catch(\Exception $exception)
        {
            throw new \Exception("Blad pobierania finansowania produkcji. ".$exception->getMessage());
        }
    }
}

?>
